/**CHeaderFile*****************************************************************

  FileName    [varInt.h]

  PackageName [var]

  Synopsis    [Internal declarations for the multi-valued variable package.]

  Description []

  SeeAlso     []

  Author      [Yuji Kukimoto]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: varInt.h,v 1.2 1998/05/19 22:04:27 hsv Exp $]

******************************************************************************/

#ifndef _VARINT
#define _VARINT

#include "var.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define VarPI (01)
#define VarPO (02)
#define VarPS (04)
#define VarNS (010)
#define VarSI (020)
#define VarSO (040)

/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/

/**Struct**********************************************************************

  Synopsis    [A multi-valued variable.]

  Description [A multi-valued variable.]

******************************************************************************/
struct VarVariableStruct {
  char  *name;	            /* name of variable */
  Hrc_Node_t  *hnode;       /* hnode to which variable belongs  */
  int type;                 /* type of variable, PI/PO/PS/NS/SI/SO
                               (SI for subcircuit input and SO for subcircuit output)
                               six Boolean flags are stored in a single int var
                               Slot assignments in the int data structure are
                               from LSB, PI, PO, PS, NS, SI, SO */
  int  numValues;           /* number of values in domain */
  array_t  *indexToValue;   /* int -> char *: used only for symbolic variables */
  st_table  *valueToIndex;  /* char * -> int: used only for symbolic variables */
  int numFanoutTables;      /* number of normal tables (\neq reset tables)
                               in which the variable appears as an input
                               Used by write_blif  */
  char  *typeIdentifier;    /* type identifier associated with variable */
                            /* (use w/ the blif-mv .type statement) */

  void  *undef;             /* for programmer's usage */
};


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/

#endif /* _VARINT */
