/**CFile***********************************************************************

  FileName    [vmInit.c]

  PackageName [vm]

  Synopsis    [Initializes and ends VIS.]

  Author      [Originated from SIS]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

******************************************************************************/

#include "vmInt.h"

static char rcsid[] UNUSED = "$Id: vmInit.c,v 1.17 2004/12/27 00:25:32 bli Exp $";

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Calls the initialization routines of all the packages.]

  SideEffects [Sets the global variables vis_stdout, vis_stderr,
  vis_historyFile.]

  SeeAlso     [VmEnd]

******************************************************************************/
void
VmInit(void)
{
  vis_stdout      = stdout; 
  vis_stderr      = stderr;
  vis_historyFile = NIL(FILE);
  
  Cmd_Init();
  Tst_Init();
  Tbl_Init();
  Io_Init();
  Hrc_Init();
  Rst_Init();
  Ntk_Init();
  Ord_Init();
  Ntm_Init();
  Ctlp_Init();
  Ctlsp_Init();  
  Fsm_Init();
  Ltl_Init();    
  Grab_Init();   
  Sim_Init();
  Part_Init();
  Mvf_Init();
  Img_Init();
  Mc_Init();
  Eqv_Init();
  Amc_Init();
  Res_Init();
  Synth_Init();
  Abs_Init();
  Restr_Init();
  Imc_Init();
  Spfd_Init();
  Truesim_Init();
  Rt_Init();
  bAig_Init();
  mAig_Init();
  MvfAig_Init();
  ntmaig_Init();
  Bmc_Init();
  PureSat_Init();
  Rob_Init();
}


/**Function********************************************************************

  Synopsis    [Calls the end routines of all the packages.]

  SideEffects [Closes the output files if not the standard ones.]

  SeeAlso     [VmInit]

******************************************************************************/
void
VmEnd(void)
{
  Synth_End();
  Amc_End();
  Eqv_End();
  Mc_End();
  Img_End();
  Mvf_End();
  Part_End();
  Sim_End();
  Fsm_End();
  Grab_End();
  Ltl_End();   
  Ctlp_End();
  Ctlsp_End(); 
  Ntm_End();
  Ord_End();
  Ntk_End();
  Rst_End();
  Hrc_End();
  Tbl_End();
  Io_End();
  Res_End();
  Tst_End();
  Cmd_End();
  Abs_End();
  Restr_End();
  Imc_End();
  Spfd_End();
  Truesim_End();
  Rt_End();
  bAig_End();
  mAig_End();
  MvfAig_End();
  ntmaig_End();
  Bmc_End();
  Rob_End();
  if (vis_stdout != stdout) {  
    (void) fclose(vis_stdout);
  } 
  if (vis_stderr != stderr) {
    (void) fclose(vis_stderr);
  }
  if (vis_historyFile != NIL(FILE)) {
    (void) fclose(vis_historyFile);
  }
  
  vis_stdout      = stdout;
  vis_stderr      = stderr;
  vis_historyFile = NIL(FILE);
}


/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/
