/*
 *  Utilities for handling sets.
 *
 *  Copyright (c) 1992, 1993
 *        Regents of the University of California
 *  All rights reserved.
 *
 *  Use and copying of this software and preparation of derivative works
 *  based upon this software are permitted.  However, any distribution of
 *  this software or derivative works must include the above copyright 
 *  notice.
 *
 *  This software is made available AS IS, and neither the Electronics
 *  Research Laboratory or the Universify of California make any
 *  warranty about the software, its performance or its conformity to
 *  any specification.
 *
 *  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/stack/stack.c,v 1.1.1.1 2001/07/09 23:22:44 fabio Exp $
 *
 * Author: STCheng, stcheng@ic.berkeley.edu
 */

#include <stdio.h>
#include "util.h"
#include "list.h"
#include "stack.h"

lsList create_stack()
{
    return lsCreate();
}

void destroy_stack(stack, del_func)
lsList stack;
void (*del_func)();
{
    (void) lsDestroy(stack, del_func);
}

void push_stack(obj_stack, item)
lsList obj_stack;
void *item;
{
    lsNewEnd(obj_stack, item, 0);
}

void *pop_stack(obj_stack, item)
lsList obj_stack;
void **item;
{
    if (lsDelEnd(obj_stack, (lsGeneric*)item) == LS_NOMORE) {
	*item = NIL(void);
	return *item;
    } 

    return *item;
}

void *top_stack(obj_stack)
lsList obj_stack;
{
    void *item;

    if (lsLastItem(obj_stack, (lsGeneric*)&item, 0) == LS_NOMORE) {
	item = NIL(void);
	return item;
    }

    return item;
}
