/*

  Copyright (c) 1992, 1993
	Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
	  10/92
	  10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/main.c,v 1.2 2009/03/09 20:25:57 fabio Exp $


*/

#include <stdio.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include "util.h"
#include "array.h"
#include "st.h"
#include "list.h"
#include "set.h"
#include "stack.h"
#include "vl_types.h"
#include "vl_defs.h"
#include "vlr_int.h"
#include "vl_traverse.h"
#include "vl_write.h"
#include "vl_mux.h"
#include "verilog.h"

extern vl_descPtr vl_description;
extern int YYTrace;
extern lsList vl_module_stack;
extern lsList vl_cur_type_stack;
extern st_table *macros;
extern int PrtEnable;
extern int dumpSyncCkt;
extern int dflow_analysis;
extern int Loop_Unrolling;
extern int Repeat_Unrolling;
extern int do_encoding;
extern int debug_mode;
extern int Use_MV_Lib;
extern int set_notation;
extern int implicitDeclare;
extern int implicitClocking;
extern int combinationalReduction;
extern int chk_IncompleteBranch;
extern int vlTimedSystem;
extern int wireRegister;
extern int portPerLine;
extern int compatibleChecking;
extern int use_libraryGate;
extern int vis_nond;
extern int vl_noTimers;
extern int decomposeTable;
extern int smartEvent;
extern int indexAssignment;
extern int NoDetailedComment;
extern int implicitClockWire;
extern int arrayBoundNond;
extern int RQautomata;
extern int deadlock_semantic;
extern int Zconnection;
extern char *vl_filename;
extern FILE *yyin;
extern FILE *mv_file;
extern FILE *open_file();
extern stack_t file_stack;
extern stack_t fname_stack;
extern stack_t lineno_stack;
extern stack_t buffer_stack;
extern int instantiateAll;
extern FILE *null_file;

FILE *vl_OutStream=NIL(FILE);
char *vl_OutStreamName=NIL(char);

FILE *siserr;

int noBus=0;

int WarningLevel=0;
int vlPhase=0;
int encodeTimer=1;
int userControlLibraryGate=0;

char *opts = "AbBcdD:eEf:FgiIklMnNo:OpPrR:StT:uvwW:xyZz";
int ith_module = 0;

int Warn_Uninitialized = 0;
int Warn_DuplicateInst = 0;

#define VIS_LIB_PATH	"VIS_LIBRARY_PATH"
#define SISLIB_MV       "sislib.mv"
#define SISLIB_V        "sislib.v"

UNUSED static char rcsid[] = "$Id: main.c,v 1.2 2009/03/09 20:25:57 fabio Exp $";

static void usage ARGS((char *cmd));
static void predefine_macros ARGS((st_table *macros));

int main(int argc, char *argv[])
{
#ifdef _IBMR2
    int c;
#else
    char c;
#endif
    lsHandle handle;
    lsGen gen;
    vl_module *mod;
    int i;
    int dumpOnly=0;
    int use_stdout=0;
    char *out_filename = NIL(char);
    struct timeval tval;
    struct timezone tzone;
    struct tm *current_time;
    char buf[MAXSTRLEN];
    extern int optind;
    extern char *optarg;
    extern int use_rst_ckt;

    mv_file = stdout;
    siserr = stderr;

    gettimeofday(&tval, &tzone);
    current_time = localtime((time_t *)(&(tval.tv_sec)));


    macros = st_init_table(strcmp, st_strhash);
    predefine_macros(macros);


    vl_module_stack = lsCreate();
    vl_cur_type_stack = lsCreate();

    if (argc <= 1) {
	usage(argv[0]);
    }

    while ((c = getopt(argc, argv, opts)) != EOF) {
	switch (c) {
	case 'A': use_stdout=1; break;
	case 'b': noBus=1; break;
	case 'B': chk_IncompleteBranch = 0; break;
	case 'c': implicitClocking = 0; vlTimedSystem = 1; break;
	case 'C': compatibleChecking = 1; break;
	case 'd': PrtEnable=1; dumpOnly=1; break;
	case 'D':
	    switch (*optarg) {
	    case 'l': dflow_analysis |= DF_UninitVar; break;
	    default: usage(argv[0]);
	    }
	    break;
	case 'e': do_encoding = 1; break;
	case 'E': smartEvent = 0; break;
	case 'f': portPerLine = atoi(optarg); break;
	case 'F': vl_noTimers = 1; break;
	case 'g': debug_mode=1; break;
	case 'i': implicitDeclare=0; break;
	case 'I': instantiateAll=0; break;
	case 'k': deadlock_semantic = 1; break;
	case 'l': Use_MV_Lib=1; break;
	case 'L': userControlLibraryGate = 1; break;
	case 'M': NoDetailedComment=1; break;
	case 'n': dumpSyncCkt=1; break;
	case 'N': arrayBoundNond=1; break;
	case 'o': out_filename = vlStrdup(optarg); break;
	case 'O': combinationalReduction = 1; break;
	case 'P': Repeat_Unrolling = ~Repeat_Unrolling; break;
	case 'p': PrtEnable=1; break;
	case 'R': if (!strcmp(optarg,"Uninitialized")) Warn_Uninitialized=1;
		  if (!strcmp(optarg,"DuplicateInst")) Warn_DuplicateInst=1;
	  break;
	case 'r': use_rst_ckt = 1; break;
	case 'S': set_notation=0; break;
	case 't': YYTrace=1; break;
	case 'T': decomposeTable = atoi(optarg); break;
	case 'u': Loop_Unrolling=0; break;
	case 'v': implicitClockWire=1; break;
	case 'w': wireRegister=1; break;
	case 'W': WarningLevel = atoi (optarg); break;
	case 'x': indexAssignment = 1; break;
	case 'y': RQautomata = 0; break;
	case 'Z': vis_nond = 0; break;
	case 'z': Zconnection = 1; break;
	default: usage(argv[0]);
	}
    }


    file_stack = create_stack();
    fname_stack = create_stack();
    lineno_stack = create_stack();
    buffer_stack = create_stack();
    vl_filename = argv[optind];
    yyin = fopen(argv[optind],"r");
    fprintf(stderr, "%s\n", vl_filename);
    if (!yyin) {
	fprintf(stderr, "failed to open file %s\n", vl_filename);
	exit(1);
    }


    vlPhase = 0;
    if (yyparse())
	printf("-- parsing failure\n");
    chk_mp_definitions(vl_description->mp_undefined);

    if (!use_stdout) {
	if (!out_filename) {
	    char *tmp_filename;
	    tmp_filename = basename(vl_filename);
	    out_filename = chk_malloc(strlen(tmp_filename)+15);
	    strcpy(out_filename, tmp_filename);
	    strcat(out_filename, ".mv");
	    vl_OutStreamName = vlStrdup(out_filename);
	    vl_OutStream = mv_file = open_file(out_filename, "w");
	    vl_chk_free(out_filename);
	    out_filename = NIL(char);
	} else {
	    vl_OutStreamName = vlStrdup(out_filename);
	    vl_OutStream = mv_file = open_file(out_filename, "w");
	    vl_chk_free(out_filename);
	    out_filename = NIL(char);
	}
    }

    null_file = open_file("/dev/null", "w");
    fprintf(mv_file, "%s ", HSIS_COMMENT);
    for (i=0; i<argc; i++) {
	fprintf(mv_file, "%s ", argv[i]);
    }
    fprintf(mv_file, "\n");
    fprintf(mv_file, "%s version: %s\n", HSIS_COMMENT, VL2MV_VERSION);
    strftime(buf, MAXSTRLEN, "%T %m/%d/%Y (%Z)", current_time);
    fprintf(mv_file, "%s date:    %s\n", HSIS_COMMENT, buf);

    vlPhase = 1;

    for (gen=lsStart(vl_description->modules);
	 lsNext(gen, (lsGeneric*)&mod, &handle) != LS_NOMORE; ) {
	vl_step_desc(mod->name->name, (char*)mod, NIL(char));
    }
    lsFinish(gen);

    if (!dumpOnly) {

	vlPhase = 2;
	PrtEnable = 1;
	gen = lsStart(vl_description->modules);
	while (lsNext(gen, (lsGeneric*)&mod, &handle) != LS_NOMORE) {
	    vl_write_desc(mod->name->name, (char*)mod, NIL(char));
	    ith_module++;
	}
	vl_dump_libs(mv_file, vl_description->decl_st);
    }

    if (use_libraryGate) {
	if (!userControlLibraryGate) {
	    char *visLibPath;
	    if ((visLibPath=getenv(VIS_LIB_PATH))) {
		char *file_path;
		if ((file_path = util_file_search(SISLIB_MV,visLibPath,"r"))) {
		    fprintf(mv_file, ".include %s\n", SISLIB_MV);
		} else if ((file_path = util_file_search(SISLIB_V,
							visLibPath, "r"))) {
		   if (!(yyin = fopen(file_path, "r"))) {
			fprintf(stderr, "fail to open %s\n", file_path);
			exit(1);
		   }
		   yylineno = 1;
		   if (yyparse()) {
			fprintf(stderr, "parsing failure for library file %s\n",
				file_path);
			exit(1);
		   }
		   fclose(yyin);
		} else {
		    fprintf(stderr, "cannot file sislib.mv/sislib.v in $%s, insert \".include sislib.mv\" in your generated mv file\n",
			    VIS_LIB_PATH);
		    fprintf(mv_file, ".include %s\n", SISLIB_MV);
		}
	    } else {
		fprintf(stderr, "cannot file sislib.mv/sislib.v in $%s, insert \".include sislib.mv\" in your generated mv file\n",
			VIS_LIB_PATH);
		fprintf(mv_file, ".include %s\n", SISLIB_MV);
	    }
	}
    }

    return 0;
}

static void usage(char *cmd)
{
    fprintf(stderr, "usage: %s -%s <filename>\n", cmd, opts);
    fprintf(stderr, "\tversion %s\n", VL2MV_VERSION);
    fprintf(stderr, "       -A        : dump output to stdout\n");
    fprintf(stderr, "       -b        : no multiple output for bus connection\n");
    fprintf(stderr, "       -B        : disable check incomplete branches\n");
    fprintf(stderr, "       -c        : explicit clocking\n");

    fprintf(stderr, "       -d        : dump internal representation only\n");


    fprintf(stderr, "       -E        : turn off smart event (save register)\n");
    fprintf(stderr, "       -f        : split line for long port lists\n");
    fprintf(stderr, "       -F        : ignore all timing (watch out!!)\n");
    fprintf(stderr, "       -g        : put debugging information\n");
    fprintf(stderr, "       -i        : turn off auto declaration of 1-bit wires\n");
    fprintf(stderr, "       -I        : supress declaration of modules of included file when `VL2MVundefMod is in place\n");
    fprintf(stderr, "       -L        : users wish to control the generation of gates instead of using default search/generation schemes.\n");

    fprintf(stderr, "       -M        : forbidden verbose comments\n");
    fprintf(stderr, "       -n        : check if create physically clocked latches\n");
    fprintf(stderr, "       -N        : use nondeterminism for out-of-bound array access\n");
    fprintf(stderr, "       -o <file> : send output to <file>\n");
    fprintf(stderr, "       -O        : combinational reduction\n");
    fprintf(stderr, "       -P        : disable repeat loop unrolling\n");
    fprintf(stderr, "       -p        : dump internal representation\n");

    fprintf(stderr, "       -R <warn> : provide various warning messages\n");
    fprintf(stderr, "          <warn> = Uninitialized DuplicateInst\n");
    fprintf(stderr, "       -t        : dump parsing trace\n");
    fprintf(stderr, "       -T <width>: decompose nonblocking assignment table wider than <width>\n");
    fprintf(stderr, "       -u        : turn off loop unrolling\n");
    fprintf(stderr, "       -v        : wire for 'clocks' in implicit clocking\n");
    fprintf(stderr, "       -w        : put register to prevent self reference wire in alwyas stmt\n");
    fprintf(stderr, "       -W <level>: set warning level\n");
    fprintf(stderr, "       -x        : put in assignment to idnex variable in for-loop unrolling\n");
    fprintf(stderr, "       -y        : do not attempt to make Timing Maching RQ (save states)\n");
    fprintf(stderr, "       -z        : use wire-or for resolution function instead of conflict arbiter\n");
    fprintf(stderr, "                   useful for hi-Z modeling\n");
    fprintf(stderr, "       -Z        : (turn on) limit $ND to only continuous assignments for VIS\n");
    fprintf(stderr, "                 : WARNING: when this is on, only \"assign <id> = $ND(...);\" is allowed\n");
    exit(255);
}

void vl_exit(int code)
{
    if (vl_OutStream != NIL(FILE))
	unlink(vl_OutStreamName);
    exit(code);
}

char *predefined_symbols[] = {
    "__vl2mv__",
    "__synth__",
    NULL
};

static void predefine_macros(st_table *macros)
{
    int i;
    char *cp;

    for (i=0 ; (cp=predefined_symbols[i]); i++) {
	st_insert(macros, cp, " ");
    }
}
