/*

  Copyright (c) 1992, 1993
	Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
	  10/92
	  10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_clock.c,v 1.2 2009/03/09 20:25:57 fabio Exp $


*/

#include "util.h"
#include "st.h"
#include "list.h"
#include "array.h"
#include "set.h"
#include "stack.h"
#include "graph.h"
#include "vl_defs.h"
#include "vl_types.h"
#include "vlr_int.h"
#include "vl_fg_defs.h"
#include "vl_fg_types.h"
#include "vl_flowgraph.h"
#include "vl_create.h"
#include "vl_write_util.h"
#include "verilog.h"

extern vl_desc *mod_list;


void register_vl2mv_synClock(char *cname, int edge, int pi, float rho)
{
    vl_synClock *synclock;
    char buf[MAXSTRLEN];

    if (edge > 1 || edge < 1 || pi < 0 || rho < 0.0) {
	sprintf(buf, "invalid VL2MVClock spec.: name=%s edge=%d pi=%d rho=%f",
		cname, edge, pi, rho);
	compile_error(buf);
    }

    synclock = (vl_synClock*)chk_malloc(sizeof(vl_synClock));
    synclock->name = vlStrdup(cname);
    synclock->edge = edge;
    synclock->pi   = pi;
    synclock->rho  = rho;

    if (mod_list)
	st_insert(mod_list->synclock_st, vlStrdup(cname),
		  (char*)synclock);
}
