/*

  Copyright (c) 1992, 1993
	Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
	  10/92
	  10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_vardecl.c,v 1.2 2009/03/09 20:25:58 fabio Exp $


*/

#include <stdio.h>
#include <math.h>
#include "util.h"
#include "array.h"
#include "list.h"
#include "st.h"
#include "set.h"
#include "vl_types.h"
#include "vl_defs.h"
#include "vlr_int.h"
#include "vl_fg_defs.h"
#include "vl_create.h"
#include "vl_write.h"
#include "vl_write_util.h"
#include "vl_vardecl.h"


void write_var_decl(file, term)
FILE *file;
vl_term *term;
{
    if (term->flag & MVar)
	write_mvar_decl(file, term);
}


void write_mvar_decl(file, term)
FILE *file;
vl_term *term;
{
    lsList domain;
    lsGen enum_gen;
    vl_enumerator *enum_elt;

    if (!(term->flag & MVar)) return;

    domain = term->term_type->specifier->u.enum_type->domain_list;
    if (!term->name->range) {
	int i;

	fprintf(file, ".mv %s %d ", term->name->name, lsLength(domain));
	for (enum_gen=lsStart(domain), i=0;
	     lsNext(enum_gen, &enum_elt, LS_NH)!=LS_NOMORE; i++) {
	    fprintf(file, "%s ", enum_elt->name);
	}
	lsFinish(enum_gen);
	fprintf(file, "\n");
    } else {
	int array_lo, array_hi, array_idx;
	array_lo = vl_eval_expr(term->name->range->left);
	if (term->name->range->right)
	    array_hi = vl_eval_expr(term->name->range->right);
	else
	    array_hi = array_lo;

	for (array_idx=array_lo; array_idx<=array_hi; array_idx++) {
	    fprintf(file, ".mv %s%s%d%s %d ",
		    term->name->name, SEP_LARRAY, array_idx, SEP_RARRAY,
		    lsLength(domain));
	    for (enum_gen=lsStart(domain);
		 lsNext(enum_gen, &enum_elt, LS_NH)!= LS_NOMORE;) {
		fprintf(file, "%s ", enum_elt->name);
	    }
	    lsFinish(enum_gen);
	    fprintf(file, "\n");
	}
    }
}
