#ifndef _VERILOG_H
#define _VERILOG_H

EXTERN int empty_file_stack ARGS((void));
EXTERN int  find_macro ARGS((char *str));
EXTERN int find_not_macro ARGS((char *str));
EXTERN void lex_panic ARGS((char *mesg));
EXTERN void pushd ARGS((char *filename));
EXTERN void popd ARGS((void));

EXTERN int yyparse ARGS((void));

EXTERN void compile_error ARGS((char* str));
EXTERN void semantic_error ARGS((char *str));
EXTERN void internal_error ARGS((char *str));
EXTERN void Translate_Warning ARGS((char *str));
EXTERN void Translate_Notice ARGS((char *str));
EXTERN void chk_mp_definitions ARGS((st_table *undefined));
EXTERN int str_matchtail ARGS((char *str, char *pat));

EXTERN void vl_exit ARGS((int code));
EXTERN int lcm ARGS((int u, int v));
EXTERN void collect_quasi ARGS((char *name));
EXTERN void dup_info_var_in_st ARGS((st_table *vars));
EXTERN void reset_cond_list_in_st ARGS((st_table *vars));
EXTERN void reset_mvar_latch ARGS((FILE *file, int non_block_var,
				   vl_id_range *id_sym,
				   int lo, int hi, char *lname));
EXTERN void instantiate_mvar_latch ARGS((FILE *file,
					 int non_block_var,
					 int mark_sel_var, int lo, int hi,
					 vl_id_range *id_sym,
					 vl_id_range *orig_id_sym,
					 var_info *lhsvar,
					 char *lname));
EXTERN void instantiate_bin_scalar_latch ARGS((FILE *file,
					       int non_block_var,
					       int mark_sel_var,
					       vl_id_range *id_sym,
					       vl_id_range *orig_id_sym,
					       var_info *lhsvar,
					       char *lname));
EXTERN void instantiate_bin_vector_latch ARGS((FILE *file,
					       int non_block_var,
					       int mark_sel_var,
					       int lo, int hi,
					       vl_id_range *id_sym,
					       vl_id_range *orig_id_sym,
					       var_info *lhsvar,
					       char *lname));
EXTERN void reset_bin_scalar_latch ARGS((FILE *file, int non_block_var,
					 vl_id_range *id_sym, char *lname));
EXTERN void reset_bin_vector_latch ARGS((FILE *file, int non_block_var,
					 vl_id_range *id_sym,
					 int lo, int hi, char *lname));
EXTERN void create_mvar_nondeterminism ARGS((FILE *file,
					     st_table *resultant_vars,
					     char *var_name,
					     vl_id_range *id_sym,
					     int lo, int hi, 
					     array_t *controls,
					     array_t *vars_array));
EXTERN void create_bin_scalar_nondeterminism ARGS((FILE *file,
						   st_table *resultant_vars,
						   char *var_name,
						   vl_id_range *id_sym, 
						   array_t *controls,
						   array_t *vars_array));
EXTERN void create_bin_vector_nondeterminism ARGS((FILE *file,
						   st_table *resultant_vars,
						   char *var_name, 
						   vl_id_range *id_sym,
						   int lo, int hi,
						   array_t *controls,
						   array_t *vars_array));

EXTERN void collect_latch ARGS((char *name));
EXTERN int drive_strength ARGS((int strength0, int strength1));
EXTERN void extract_delay_strength ARGS((lsList delay_strength,
					 vl_delay **delay,
					 int *strength));
EXTERN void insert_instances ARGS((lsList inst_list, void *inst_master));
EXTERN void associate_symbolic_value ARGS((vl_lval *lval, vl_expr *expr));
EXTERN void push_open_file ARGS((char *fname));
EXTERN void register_vl2mv_synClock ARGS((char *cname, int edge, int pi, float rho));
EXTERN void encodebit ARGS((char *instr, int *part1, int *part0));
EXTERN void pop_close_file ARGS(());


#endif /* _VERILOG_H */
