/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_defs.h,v 1.1.1.1 2001/07/09 23:22:42 fabio Exp $


*/



#define EnumType        1






#define LastCellNum   	142

#define None		0
#define CombPrimDecl	1
#define SeqPrimDecl	2
#define ModDecl		3


#define RealDecl	4
#define IntDecl		5
#define TimeDecl	6
#define EventDecl	7


#define InputDecl	8
#define OutputDecl	9
#define InoutDecl	10
#define RegDecl		11


#define ParamDecl	12
#define DefparamDecl	13


#define WireDecl	14
#define TriDecl		15
#define Tri0Decl	16
#define Tri1Decl	17
#define Supply0Decl	18
#define Supply1Decl	19
#define WandDecl	20
#define TriandDecl	21
#define WorDecl		22
#define TriorDecl	23
#define TriregDecl	24


#define ContAssign	25


#define TaskDecl	26
#define IntFuncDecl	27
#define RealFuncDecl	28
#define RangeFuncDecl	29


#define AndGate		30
#define NandGate	31
#define OrGate		32
#define NorGate		33
#define XorGate		34
#define XnorGate	35
#define BufGate		36
#define Bufif0Gate	37
#define Bufif1Gate	38
#define NotGate		39
#define Notif0Gate	40
#define Notif1Gate	41
#define PulldownGate	42
#define PullupGate	43
#define NmosGate	44
#define RnmosGate	45
#define PmosGate	46
#define RpmosGate	47
#define CmosGate	48
#define RcmosGate	49
#define TranGate	50
#define RtranGate	51
#define Tranif0Gate	52
#define Rtranif0Gate	53
#define Tranif1Gate	54
#define Rtranif1Gate	55

#define PrimInst	56
#define ModInst		57

#define AlwaysStmt	58
#define InitialStmt	59


#define BeginEndStmt	60
#define IfElseStmt	61
#define CaseStmt	62
#define CasexStmt	63
#define CasezStmt	64
#define ForeverStmt	65
#define RepeatStmt	66
#define WhileStmt	67
#define ForStmt		68
#define DelayControlStmt	69
#define EventControlStmt	70
#define BassignStmt	71
#define NbassignStmt	72
#define DelayBassignStmt	73
#define DelayNbassignStmt	74
#define EventBassignStmt	75
#define EventNbassignStmt	76
#define WaitStmt	77
#define ForkJoinStmt	78
#define TaskEnableStmt	79
#define SysTaskEnableStmt	80
#define DisableStmt	81
#define AssignStmt	82
#define DeassignStmt	83

#define CaseItem	84
#define DefaultItem	85


#define OrEventExpr	86
#define NegedgeEventExpr	87
#define PosedgeEventExpr	88
#define EdgeEventExpr           141
#define EventExpr	89


#define IDExpr		90
#define BitSelExpr	91
#define PartSelExpr	92
#define ConcatExpr	93
#define MinTypMaxExpr	94

#define BitExpr         138
#define IntExpr		95
#define RealExpr	96
#define StringExpr	97
#define FuncExpr	98
#define UplusExpr	99	
#define UminusExpr	100	
#define UnotExpr	101	
#define UcomplExpr	102	

#define UandExpr	103	
#define UnandExpr	104	
#define UorExpr		105	
#define UnorExpr	106	
#define UxorExpr	107	
#define UxnorExpr	108	

#define BplusExpr	109	
#define BminusExpr	110	
#define BtimesExpr	111	
#define BdivExpr	112	
#define BremExpr	113	
#define Beq2Expr	114	
#define Bneq2Expr	115	
#define Beq3Expr	116	
#define Bneq3Expr	117	
#define BlandExpr	118	
#define BlorExpr	119	
#define BltExpr		120	
#define BleExpr		121	
#define BgtExpr		122	
#define BgeExpr		123	
#define BandExpr	124	
#define BorExpr		125	
#define BxorExpr	126	
#define BxnorExpr	127	
#define BlshiftExpr	128	
#define BrshiftExpr	129	

#define TcondExpr	130	

#define NondExpr        142


#define LastPrimNum 21

#define PrimNone     0
#define Prim0        1
#define Prim1        2
#define PrimX        3
#define PrimQ        4   
#define PrimR        5
#define PrimF        6
#define PrimP        7
#define PrimN        8
#define PrimS        9   
#define PrimM       10   
#define PrimB       18
#define Prim0X      11
#define Prim1X      12
#define PrimX0      13
#define PrimX1      14
#define PrimXB      15   
#define PrimBX      16   
#define PrimBB      17   
#define PrimQ0      19 
#define PrimQ1      20
#define PrimQB      21




#define Supply0Supply1  3
#define Supply0Strong1  4
#define Supply0Pull1    5
#define Supply0Weak1    6
#define Supply0HighZ1   7
#define Strong0Supply1  8
#define Strong0Strong1  9
#define Strong0Pull1   10
#define Strong0Weak1   11
#define Strong0HighZ1  12
#define Pull0Supply1   13
#define Pull0Strong1   14
#define Pull0Pull1     15
#define Pull0Weak1     16
#define Pull0HighZ1    17
#define Weak0Supply1   18
#define Weak0Strong1   19
#define Weak0Pull1     20
#define Weak0Weak1     21
#define Weak0HighZ1    22
#define HighZ0Supply1  23
#define HighZ0Strong1  24
#define HighZ0Pull1    25
#define HighZ0Weak1    26
#define HighZ0HighZ1   27
#define Supply1Supply0 28
#define Supply1Strong0 29
#define Supply1Pull0   30
#define Supply1Weak0   31
#define Supply1HighZ0  32
#define Strong1Supply0 33
#define Strong1Strong0 34
#define Strong1Pull0   35
#define Strong1Weak0   36
#define Strong1HighZ0  37
#define Pull1Supply0   38
#define Pull1Strong0   39
#define Pull1Pull0     40
#define Pull1Weak0     41
#define Pull1HighZ0    42
#define Weak1Supply0   43
#define Weak1Strong0   44
#define Weak1Pull0     45
#define Weak1Weak0     46
#define Weak1HighZ0    47
#define HighZ1Supply0  48
#define HighZ1Strong0  49
#define HighZ1Pull0    50
#define HighZ1Weak0    51
#define HighZ1HighZ0   52

#define Small          53
#define Medium         54
#define Large          55



#define Range_Dcl     131
#define Integer_Dcl   132
#define Real_Dcl      133
#define MOST_SB       (1>>31)
#define LEAST_SB      1

#define ModulePort    134
#define NamedPort     135
#define ModuleConnect 136
#define NamedConnect  137


#define SendEventStmt 139


#define SWireDecl     140




#define MVar            (1)       
#define InPort          (1<<1)    
#define OutPort         (1<<2)    
#define RegVar          (1<<3)    
#define WireVar         (1<<4)    
#define HiddenLatch     (1<<5)    
#define UninitializeVar (1<<10)   
                                  
                                  
#define AccessedVar     (1<<11)   
#define EdgeDetector    (1<<12)   
#define AutoDeclared    (1<<13)   
                                  
                                  
#define EventVar        (1<<8)    
#define TautologyTrue   (1<<14)   
#define ConflictFalse   (1<<15)   
#define EdgeSignal      (1<<6)    


#define AlwaysTouched   (1<<6)
#define WithInitial     (1<<7)        


#define WithSyncho      (1)       
#define PseudoAlways    (1<<1)    
                                  
#define TimedInitStmt   (1<<2)    
                                  
                                  
                                  


#define NBASSIGN_IN_INITIAL (1)
#define NBASSIGN_IN_ALWAYS  (1<<1)


#define DF_UninitVar    (1)


#define DFLOW_Always    (1)
#define DFLOW_Initial   (1<<1)


#define LIBuand         UandExpr
#define LIBunand        UnandExpr
#define LIBuor          UorExpr
#define LIBunor         UnorExpr
#define LIBuxor         UxorExpr
#define LIBuxnor        UxnorExpr

#define LIBplus         BplusExpr 
#define LIBminus        BminusExpr
#define LIBtimes        BtimesExpr
#define LIBdiv          BdivExpr
#define LIBrem          BremExpr
#define LIBeq2          Beq2Expr
#define LIBneq2         Bneq2Expr
#define LIBeq3          Beq3Expr
#define LIBneq3         Bneq3Expr
#define LIBland         BlandExpr
#define LIBlor          BlorExpr
#define LIBlt           BltExpr
#define LIBle           BlorExpr
#define LIBgt           BgtExpr
#define LIBge           BgeExpr
#define LIBand          BandExpr
#define LIBor           BorExpr
#define LIBxor          BxorExpr
#define LIBxnor         BxnorExpr
#define LIBlshift       BlshiftExpr
#define LIBrshift       BrshiftExpr


#define LIBmux          (LastCellNum+1)
#define LIBopen         (LastCellNum+2)
#define LIBconst        (LastCellNum+3)
#define LIBconnect      (LastCellNum+4)
#define LIBint          (LastCellNum+5)
#define LIBconflict     (LastCellNum+6)
#define LIBnblock       (LastCellNum+7)
#define LIBiconnect     (LastCellNum+8)
#define LIBexpand       (LastCellNum+9)
#define LIBshrink       (LastCellNum+10)
#define LIBsubrange     (LastCellNum+11)
#define LIBindex        (LastCellNum+12)
#define TeslaTimerGate  (LastCellNum+13)


#define LIB_NAME(type)  (type==LIBmux)?    "__mux" : \
                        (type==LIBopen)?   "__open" : \
                        (type==LIBconst)?  "__const" : \
                        (type==LIBconnect)?"__connect" : \
                        (type==LIBiconnect)?"__iconnect" : \
                        (type==LIBexpand)? "__expand" : \
                        (type==LIBshrink)? "__shrink" : \
                        (type==LIBint)?    "__int" : \
                        (type==LIBconflict)?"__conflict" : \
                        (type==LIBnblock)? "__nblock" : \
                        (type==LIBuand)?   "__uand" : \
                        (type==LIBunand)?  "__unand" : \
                        (type==LIBuor)?    "__uor" : \
                        (type==LIBunor)?   "__unor" : \
                        (type==LIBuxor)?   "__uxor" : \
                        (type==LIBuxnor)?  "__uxnor" : \
                        (type==LIBplus)?   "__plus" : \
                        (type==LIBminus)?  "__minus" : \
                        (type==LIBtimes)?  "__times" : \
                        (type==LIBdiv)?    "__div" : \
                        (type==LIBrem)?    "__rem" : \
                        (type==LIBeq2)?    "__eq2" : \
                        (type==LIBneq2)?   "__neq2" : \
                        (type==LIBeq3)?    "__eq3" : \
                        (type==LIBneq3)?   "__neq3" : \
                        (type==LIBland)?   "__land" : \
                        (type==LIBlor)?    "__lor" : \
                        (type==LIBlt)?     "__lt" : \
                        (type==LIBle)?     "__le" : \
                        (type==LIBgt)?     "__gt" : \
                        (type==LIBge)?     "__ge" : \
                        (type==LIBand)?    "__and" : \
                        (type==LIBor)?     "__or" : \
                        (type==LIBxor)?    "__xor" : \
                        (type==LIBxnor)?   "__xnor" : \
                        (type==LIBlshift)? "__lshift" : \
                        (type==LIBsubrange)?"__subrange" : \
                        (type==LIBindex)?  "__index" : \
                        (type==LIBrshift)? "__rshift" : "__????"


#define HSIS_LIB_HEADER "_hsis_"
#define SYS_LIB_NAME(type)  \
                        (type==LIBmux)?    "mux" : \
                        (type==LIBopen)?   "open" : \
                        (type==LIBconst)?  "const" : \
                        (type==LIBconnect)?"connect" : \
                        (type==LIBiconnect)?"iconnect" : \
                        (type==LIBexpand)? "expand" : \
                        (type==LIBshrink)? "shrink" : \
                        (type==LIBint)?    "int" : \
                        (type==LIBconflict)?"conflict" : \
                        (type==LIBnblock)? "nblock" : \
                        (type==LIBuand)?   "uand" : \
                        (type==LIBunand)?  "unand" : \
                        (type==LIBuor)?    "uor" : \
                        (type==LIBunor)?   "unor" : \
                        (type==LIBuxor)?   "uxor" : \
                        (type==LIBuxnor)?  "uxnor" : \
                        (type==LIBplus)?   "add" : \
                        (type==LIBminus)?  "minus" : \
                        (type==LIBtimes)?  "times" : \
                        (type==LIBdiv)?    "div" : \
                        (type==LIBrem)?    "rem" : \
                        (type==LIBeq2)?    "eq2" : \
                        (type==LIBneq2)?   "neq2" : \
                        (type==LIBeq3)?    "eq3" : \
                        (type==LIBneq3)?   "neq3" : \
                        (type==LIBland)?   "and" : \
                        (type==LIBlor)?    "or" : \
                        (type==LIBlt)?     "lt" : \
                        (type==LIBle)?     "le" : \
                        (type==LIBgt)?     "gt" : \
                        (type==LIBge)?     "ge" : \
                        (type==LIBand)?    "and" : \
                        (type==LIBor)?     "or" : \
                        (type==LIBxor)?    "xor" : \
                        (type==LIBxnor)?   "xnor" : \
                        (type==LIBlshift)? "lshift" : \
                        (type==LIBsubrange)?"subrange" : \
                        (type==LIBindex)?  "index" : \
                        (type==LIBrshift)? "rshift" : "????"



#define GATE_NAME(type) (type==AndGate)?   "and" : \
                        (type==NandGate)?  "nand" : \
                        (type==OrGate)?    "or" : \
                        (type==NorGate)?   "nor" : \
                        (type==XorGate)?   "xor" : \
                        (type==XnorGate)?  "xnor" : \
                        (type==BufGate)?   "buf" : \
                        (type==Bufif0Gate)?"bufif0" : \
                        (type==Bufif1Gate)?"bufif1" : \
                        (type==NotGate)?   "not" : \
                        (type==Notif0Gate)?"notif0" : \
                        (type==Notif1Gate)?"notif1" : \
                        (type==PulldownGate)?"pulldown" : \
                        (type==PullupGate)?"pullup" : \
                        (type==NmosGate)?  "nmos" : \
                        (type==RnmosGate)? "rnmos" : \
                        (type==PmosGate)?  "pmos" : \
                        (type==RpmosGate)? "rpmos" : \
                        (type==CmosGate)?  "cmos" : \
                        (type==RcmosGate)? "rcmos" : \
                        (type==TranGate)?  "tran" : \
                        (type==RtranGate)? "rtran" : \
                        (type==Tranif0Gate)?"tranif0" : \
                        (type==Tranif1Gate)?"tranif1" : \
                        (type==Rtranif0Gate)?"rtranif0" : \
                        (type==Rtranif1Gate)?"rtranif1" : "????"
