/**HFile***********************************************************************

  FileName    [Robust.h]

  PackageName [rob]

  Synopsis    [Headers and strcutus for Robustness package.]

  Author      [Souheib Baarir, Denis Poitrenaud,J.M Ilié ]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. Paris VI].
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF PARIS VI BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

******************************************************************************/



#ifndef _ROB_H
#define _ROB_H
#include "../ntk/ntkInt.h"
#include "../hrc/hrcInt.h"
#include "../fsm/fsmInt.h"
#include "../bmc/bmcInt.h"
#include "../sat/sat.h"
#include "../sat/satInt.h"

typedef enum{ 
  ecmd,
  eofile,
  earg,
  enfile,
  eicmd,
  eiofile,
  ercmd
} type_err;

// fonctions divers
void     get_number_of_states     (Fsm_Fsm_t  *fsm, mdd_t* b, EpDouble* ep);
array_t* determine_non_protected_registers(Fsm_Fsm_t  *fsm, FILE *f);
mdd_t*   compute_error_states     (Fsm_Fsm_t  *fsm, mdd_t* reachable,
				   int verbosityLevel, int printStep,
				   FILE* protected);
mdd_t*   error_states_us_ut(Fsm_Fsm_t  *fsm, mdd_t* reachable,
				   FILE* protected);
void     compute_fair             (Fsm_Fsm_t  *fsm,int  verbosityLevel);
Hrc_Node_t  * build_golden_faulty_compo(Hrc_Manager_t * hmgr,Hrc_Node_t  * rootNode,	Hrc_Model_t * newRootModel);


int generateProtectFile(Hrc_Node_t * goldenNode, FILE *oFile,char *
instanceName);

// fonction d'évaluation de formules CTL
mdd_t*   evaluate_EF              (Fsm_Fsm_t  *fsm, mdd_t *target,
				   mdd_t* fairS, int verbosityLevel);
mdd_t*   evaluate_EG              (Fsm_Fsm_t  *fsm, mdd_t *invariant,
				   mdd_t* fairS,Fsm_Fairness_t * fairCond, 
				   int verbosityLevel);
mdd_t*   evaluate_EU              (Fsm_Fsm_t  *fsm, mdd_t* inv, 
				   mdd_t *target,mdd_t* fairS, 
				   int verbosityLevel);
mdd_t*   evaluate_AU              (Fsm_Fsm_t  *fsm, mdd_t* inv, 
				   mdd_t *target, mdd_t* fairS,
				   Fsm_Fairness_t * fairCond, 
				   int verbosityLevel);
mdd_t*   evaluate                 (Fsm_Fsm_t  *fsm,FILE* ctlfile,
				   mdd_t* fairS,
				   Fsm_Fairness_t * fairCond, 
				   int verbosityLevel);
mdd_t*  evaluate_Formula_AF_AF    (Fsm_Fsm_t  *fsm, mdd_t* Req,
				   mdd_t* forb,mdd_t* Safe,
				   int  verbosityLevel );
mdd_t*  evaluate_Formula_AF_EF    (Fsm_Fsm_t  *fsm, mdd_t* Req,
				   mdd_t* forb,mdd_t* Safe,
				   int  verbosityLevel );
mdd_t*  evaluate_Formula_EF_AF    (Fsm_Fsm_t  *fsm, mdd_t* Req,
				   mdd_t* forb,mdd_t* Safe,
				   int  verbosityLevel );
mdd_t*  evaluate_Formula_EF_EF    (Fsm_Fsm_t  *fsm, mdd_t* Req,
				   mdd_t* forb,mdd_t* Safe,
				   int  verbosityLevel );
void    callBmcRob                ( Ntk_Network_t   *network,
				    Ctlsp_Formula_t *ltlFormula,
				    array_t         *constraintArray,
				    BmcOption_t     *options);

// fonctions d'acces
mdd_t*   getForbidden              (Fsm_Fsm_t  *fsm);
mdd_t*   getRequired               (Fsm_Fsm_t  *fsm);
mdd_t*   getSafe                   (Fsm_Fsm_t  *fsm);
mdd_t*   getInitial                (Fsm_Fsm_t  *fsm);
mdd_t*   getReach                  (Fsm_Fsm_t  *fsm);
mdd_t*   getReachOrg               (Fsm_Fsm_t  *fsm );

// fonction d'affichage
void     print_number_of_states   (char* msg, Fsm_Fsm_t  *fsm, mdd_t* b);
void     print_variables_info     (Fsm_Fsm_t  *fsm);
void     error_msg                (FILE* f, char* t, type_err e);
void     conv_error_msg           (FILE* f, char* cmd, type_err e);
void     mdd_FunctionPrintMain    (mdd_manager *mgr ,mdd_t *  top, 
				   char * macro_name, FILE * f);

#endif /* _ROB_H */
