/**CHeaderFile*****************************************************************

  FileName    [debug.h]

  PackageName [debug]

  Synopsis    [Test package illustrating VIS conventions.]

  Description [This is a test package illustrating how to create a package in
  VIS. It shows how to create commands, and illustrates naming conventions.]

  Author      [Originated from SIS.]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: debug.h,v 1.2 2011/04/12 00:12:06 braun Exp $]

******************************************************************************/

#ifndef _DBG
#define _DBG

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "vm.h"
#include "../ntk/ntkInt.h"
#include "../hrc/hrcInt.h"
#include "../fsm/fsmInt.h"
#include "../bmc/bmcInt.h"
#include "../sat/sat.h"
#include "../sat/satInt.h"
#include "../rob/Robust.h"
#include "mdd.h"


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef struct DbgAbnormalStruct Dbg_Abnormal_t;

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

/**Macro***********************************************************************

  Synopsis     [Iterates over the abnormal predicates.]

  Description  [This macro iterates over the abnormal predicates. It is an error
  ]

  SideEffects  [This macro instantiates macros from the array package.  Hence
  it is advisable not to nest this macro within array macros.]

  SeeAlso      [Ntk_NodeForFreeInputs]

******************************************************************************/
#define Dbg_ForEachAbnormal(                                       \
  /* Dbg_Abnormal_t * */ abnormal   /* abnormal to iterate abn */,            \
  /* int */          i      /* local variable for iterator */,       \
  /* Ntk_Node_t * */ abn  /* abn of node */                      \
)                                                                   \
  arrayForEachItem(Ntk_Node_t *, Dbg_ReadAbn(abnormal), i, abn)
/**Macro***********************************************************************

  Synopsis     [Iterates over the abnormal predicates.]

  Description  [This macro iterates over the abnormal predicates. It is an error
  ]

  SideEffects  [This macro instantiates macros from the array package.  Hence
  it is advisable not to nest this macro within array macros.]

  SeeAlso      [Ntk_NodeForFreeInputs]

******************************************************************************/
#define Dbg_ForEachFreeInputs(                                       \
  /* Dbg_Abnormal_t * */ abnormal   /* abnormal to iterate abn */,            \
  /* int */          i      /* local variable for iterator */,       \
  /* Ntk_Node_t * */ abn  /* abn of node */                      \
)                                                                   \
  arrayForEachItem(Ntk_Node_t *, Dbg_ReadFreeInputs(abnormal), i, abn)

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void Debug_Init(void);
EXTERN void Debug_End(void);
EXTERN Dbg_Abnormal_t * Dbg_DebugAbnormalAlloc(Ntk_Network_t * network);
EXTERN void  Dbg_DebugAbnormalFree(Dbg_Abnormal_t * abn);
EXTERN void Dbg_AddAbnormalPredicatetoNetwork(Dbg_Abnormal_t* abnormal);
EXTERN void Dbg_AddAbnormalPredicate(Dbg_Abnormal_t * abn, Ntk_Node_t* abnNode);
EXTERN void Dbg_AddFreeInput(Dbg_Abnormal_t * abn, Ntk_Node_t* fNode);
EXTERN array_t* Dbg_ReadFreeInputs(Dbg_Abnormal_t *abnormal);
EXTERN array_t* Dbg_ReadAbn(Dbg_Abnormal_t *abnormal);
/**AutomaticEnd***************************************************************/

#endif /* _DBG */
