#ifndef _BASICS_H
#define _BASICS_H


#include<vector>
#include<cstdlib>
#include<iostream>

using namespace std;


class CSolverConf  
{
public:
  static bool analyzeConflicts;
  static bool doNonChronBackTracking;
   
  static bool quietMode;
  
  static bool allowComponentCaching;
  static bool allowImplicitBCP;
  
  static bool allowPreProcessing;
  
  static unsigned int secsTimeBound;   
  
  static unsigned int maxCacheSize;   // maximum Cache Size in bytes

  static bool count;

  CSolverConf();

  ~CSolverConf();

};

#ifdef COMPILE_FOR_GUI
        #define toSTDOUT(X);
#else
	#define toSTDOUT(X)	if(!CSolverConf::quietMode) cout << X;
#endif


#ifdef COMPILE_FOR_GUI
        #define toERROUT(X);
#else
	#define toERROUT(X)	if(!CSolverConf::quietMode) cout << X;
#endif
  
#ifdef DEBUG
	#define toDEBUGOUT(X) if(!CSolverConf::quietMode) cout << X;
#else
        #define toDEBUGOUT(X);	
#endif
  

enum SOLVER_StateT{

 SUCCESS,
 TIMEOUT,
 ABORTED
};  
 
enum TriValue{

 F = 0,
 W = 1,
 X = 2
 };
 

  
extern char TriValuetoChar(TriValue v);
#endif
