#!/usr/bin/python
from stratus import *

class muxe (Model) :
# declaration of the cell s external connectors
   def Interface ( self ) :
      self.ra    = SignalIn    ( "ra" , 4)
      self.d     = SignalIn    ( "d"  , 4)
      self.r     = SignalOut   ( "r"  , 4)
      self.i     = SignalIn    ( "i"  , 3)
      self.vdd   = VddIn       ( "vdd" )
      self.vss   = VssIn       ( "vss" )

# generation of the multiplexing commands
   def Netlist ( self ) :

# R selection
# ra ->  R-input 
      r_sel_a = Signal ("r_sel_a" , 1 );
      self.r_sel_a = Inst ( "no2_x1",
                            "r_sel_a",
                            map = {'i0'  : self.i[2],
                                   'i1'  : self.i[1],
                                   'nq'  : r_sel_a,
                                   'vdd' : self.vdd,
                                   'vss' : self.vss
                                  }
                          )

# D ->  R-input 

      r_sel_d = Signal ("r_sel_d" , 1 );
      self.r_sel_d = Inst ( "ao22_x2",
                            "r_sel_d",
                            map = {'i0'  : self.i[0],
                                   'i1'  : self.i[1],
                                   'i2'  : self.i[2],
                                   'q'   : r_sel_d,
                                   'vdd' : self.vdd,
                                   'vss' : self.vss
                                  }
                          )

# R-input

      self.mux = {}
      for i in range ( 4 ) :
         self.mux[i] = Inst ( "oa2a22_x2",
                              "mux%ld" % i,
                              map = {'i0'  : self.ra[i],
                                     'i1'  : r_sel_a,
                                     'i2'  : self.d[i],
                                     'i3'  : r_sel_d,
                                     'q'   : self.r[i],
                                     'vdd' : self.vdd,
                                     'vss' : self.vss
                                    }
                            )

# Instanciation de muxe
mon_muxe = muxe ( "muxe" )
mon_muxe.Interface ()
mon_muxe.Netlist ()
mon_muxe.Save ()
